/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.base;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import writer2latex.api.Converter;
import writer2latex.api.ConverterResult;
import writer2latex.api.GraphicConverter;
import writer2latex.api.OutputFile;
import writer2latex.base.ConverterResultImpl;
import writer2latex.office.ImageLoader;
import writer2latex.office.MetaData;
import writer2latex.office.OfficeReader;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.OfficeDocument;

public abstract class ConverterBase
implements Converter {
    protected GraphicConverter graphicConverter = null;
    protected OfficeDocument odDoc;
    protected OfficeReader ofr;
    protected MetaData metaData;
    protected ImageLoader imageLoader;
    protected String sTargetFileName;
    protected ConverterResultImpl converterResult = new ConverterResultImpl();

    public void setGraphicConverter(GraphicConverter graphicConverter) {
        this.graphicConverter = graphicConverter;
    }

    public void readTemplate(InputStream is) throws IOException {
    }

    public void readTemplate(File file) throws IOException {
    }

    public void readStyleSheet(InputStream is) throws IOException {
    }

    public void readStyleSheet(File file) throws IOException {
    }

    public void readResource(InputStream is, String sFileName, String sMediaType) throws IOException {
    }

    public void readResource(File file, String sFileName, String sMediaType) throws IOException {
    }

    public ConverterResult convert(File source, String sTargetFileName) throws FileNotFoundException, IOException {
        return this.convert(new FileInputStream(source), sTargetFileName);
    }

    public ConverterResult convert(InputStream is, String sTargetFileName) throws IOException {
        this.odDoc = new OfficeDocument("InFile");
        this.odDoc.read(is);
        this.ofr = new OfficeReader(this.odDoc, false);
        this.metaData = new MetaData(this.odDoc);
        this.imageLoader = new ImageLoader(this.odDoc, true);
        this.imageLoader.setGraphicConverter(this.graphicConverter);
        this.sTargetFileName = sTargetFileName;
        this.converterResult.reset();
        this.converterResult.setMetaData(this.metaData);
        if (this.metaData.getLanguage() == null || this.metaData.getLanguage().length() == 0) {
            this.metaData.setLanguage(this.ofr.getMajorityLanguage());
        }
        this.convertInner();
        return this.converterResult;
    }

    public abstract void convertInner() throws IOException;

    public MetaData getMetaData() {
        return this.metaData;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }

    public void addDocument(OutputFile doc) {
        this.converterResult.addDocument(doc);
    }

    public EmbeddedObject getEmbeddedObject(String sHref) {
        return this.odDoc.getEmbeddedObject(sHref);
    }
}

